function [fitresult, gof] = createFit(sigma2_x, ln_Cllr_y)
%CREATEFIT(SIGMA2_X,LN_CLLR_Y)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input: sigma2_x
%      Y Output: ln_Cllr_y
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 26-Apr-2023 11:00:26


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( sigma2_x, ln_Cllr_y );

% Set up fittype and options.
ft = fittype( 'b*(exp(-c*x)-1)', 'independent', 'x', 'dependent', 'y' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Display = 'Off';
opts.StartPoint = [1 1];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% % Plot fit with data.
% figure( 'Name', 'untitled fit 1' );
% h = plot( fitresult, xData, yData );
% legend( h, 'ln_Cllr_y vs. sigma2_x', 'untitled fit 1', 'Location', 'NorthEast', 'Interpreter', 'none' );
% % Label axes
% xlabel( 'sigma2_x', 'Interpreter', 'none' );
% ylabel( 'ln_Cllr_y', 'Interpreter', 'none' );
% grid on


