function lnLR = pav_transform(x_test, x_same, x_different)
% transforms scores to ln(LR) using pool-adjacent-violators algorithm
% scores must be positively correlated with strength of evidence
% for each test datum in x_test, finds closest training datum and returns ln(LR)corresponding to the latter
% if x_test is empty, returns transforms of training data
% uses Niko Brmmer's Focal Toolkit

x_same = x_same(:)';
x_different = x_different(:)';

% [y_same, y_different] = opt_loglr(x_same, x_different, 'raw'); 
% % 'raw' returns Inf for anthing beyond smallest same-source and largest different-source
% % this was necessary for Vergeer et al replication in "no_calibration_metric.m", otherwise for wide separation between 
% % same-source and diferent-source distributions, Cllr comes out smaller then Cllr_min

[y_same, y_different] = opt_loglr(x_same, x_different); 
% 'raw' is not selected for plotting PAV transformation in "perfect_calibration.m"

y_all = [y_same, y_different];

if isempty(x_test)
    lnLR = y_all;
else
    x_all = [x_same, x_different];
    x_test = x_test(:)';
    num_x_test = length(x_test);
    lnLR = NaN(1, num_x_test);
    for I_test = 1:num_x_test
        [~, II] = min(abs(x_all - x_test(I_test)));
        lnLR(I_test) = y_all(II);   
    end
end


