function [a,b] = train_LDA(scores_s, scores_d)
% outputs intercept and slope for a dichotomous linear discriminant analysis
% to transform a score to a ln likelihood ratio: logLR = a + b*score
mu_s = mean(scores_s);
mu_d = mean(scores_d);
sigma_s = std(scores_s);
sigma_d = std(scores_d);
num_s = length(scores_s);
num_d = length(scores_d);
sigma_pooled = (sigma_s*(num_s-1) + sigma_d*(num_d-1)) / (num_s + num_d - 2);
b = (mu_s - mu_d) / sigma_pooled^2;
a = -b * (mu_s + mu_d) / 2;
